/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.world.StructureSpawnManager;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MobGenerator
implements Generator.Mobs {
    private static final String DISABLE_MOBS = "disable_mob_generation";
    private static final Codec<DimensionSettings> CODEC = DimensionSettings.field_236097_a_;
    private final boolean mobSpawning;
    private final CatSpawner catSpawner = new CatSpawner();
    private final PatrolSpawner patrolSpawner = new PatrolSpawner();
    private final PhantomSpawner phantomSpawner = new PhantomSpawner();

    public MobGenerator(TFChunkGenerator generator) {
        DimensionSettings settings = generator.getDimensionSettings().get();
        this.mobSpawning = Codecs.getField(settings, CODEC, JsonElement::getAsBoolean, DISABLE_MOBS).orElse(false) == false;
    }

    @Override
    public final void generateMobs(WorldGenRegion region) {
        if (this.mobSpawning) {
            int chunkZ;
            int chunkX = region.func_201679_a();
            BiomeContainer biomes = region.func_212866_a_(chunkX, chunkZ = region.func_201680_b()).func_225549_i_();
            if (biomes == null) {
                return;
            }
            Biome biome = biomes.func_225526_b_(0, 0, 0);
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
            sharedseedrandom.func_202424_a(region.func_72905_C(), chunkX << 4, chunkZ << 4);
            WorldEntitySpawner.func_77191_a((IServerWorld)region, (Biome)biome, (int)chunkX, (int)chunkZ, (Random)sharedseedrandom);
        }
    }

    @Override
    public final void tickSpawners(ServerWorld world, boolean hostile, boolean peaceful) {
        this.phantomSpawner.func_230253_a_(world, hostile, peaceful);
        this.patrolSpawner.func_230253_a_(world, hostile, peaceful);
        this.catSpawner.func_230253_a_(world, hostile, peaceful);
    }

    @Override
    public final List<MobSpawnInfo.Spawners> getSpawns(Biome biome, StructureManager structures, EntityClassification type, BlockPos pos) {
        List spawns = StructureSpawnManager.getStructureSpawns((StructureManager)structures, (EntityClassification)type, (BlockPos)pos);
        if (spawns != null) {
            return spawns;
        }
        if (structures.func_235010_a_(pos, true, (Structure)Structure.field_236374_j_).func_75069_d()) {
            if (type == EntityClassification.MONSTER) {
                return Structure.field_236374_j_.getDefaultSpawnList();
            }
            if (type == EntityClassification.CREATURE) {
                return Structure.field_236374_j_.getDefaultCreatureSpawnList();
            }
        }
        if (type == EntityClassification.MONSTER) {
            if (structures.func_235010_a_(pos, false, Structure.field_236366_b_).func_75069_d()) {
                return Structure.field_236366_b_.func_202279_e();
            }
            if (structures.func_235010_a_(pos, false, Structure.field_236376_l_).func_75069_d()) {
                return Structure.field_236376_l_.func_202279_e();
            }
            if (structures.func_235010_a_(pos, true, Structure.field_236378_n_).func_75069_d()) {
                return Structure.field_236378_n_.func_202279_e();
            }
        }
        return biome.func_242433_b().func_242559_a(type);
    }
}

